/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.ppp;

import ibm.nways.jdm.I18NGiblets;
import ibm.nways.jdm.I18NMsgFormat;
import ibm.nways.jdm.I18NString;
import ibm.nways.jdm.JdmServerImpl;
import ibm.nways.jdm.StatusType;
import ibm.nways.jdm.modelgen.StatusMapper;
import ibm.nways.jdm.modelgen.StatusModelInfo;
import ibm.nways.jdm.modelgen.TableStatusNamer;
import java.util.Locale;

public class ActionPppProtocol
implements StatusMapper,
TableStatusNamer {
    private static String bundleName = "ibm.nways.ppp.Resources";
    private static String enumBundle = "ibm.nways.ppp.eui.EnumeratedResources";
    private boolean loggingOn = false;

    public ActionPppProtocol() {
        String string = JdmServerImpl.getProperty("startLogging");
        if (string != null && string.equals("yes")) {
            this.loggingOn = true;
        }
    }

    public void calculateStatus(StatusModelInfo statusModelInfo, StatusModelInfo statusModelInfo2) {
        try {
            Object[] objectArray = statusModelInfo.getIndexes();
            if (this.loggingOn) {
                System.out.println("ActionPppProtocol");
                System.out.println("Interface = " + objectArray[0] + " Protocol = " + objectArray[1]);
                System.out.println("pppProtocolState = " + statusModelInfo.get("Panel.PppProtocolState"));
            }
            StatusAndExplain statusAndExplain = this.evaluateStatus((Integer)statusModelInfo.get("Panel.PppProtocolState"), objectArray);
            statusModelInfo.setStatusType(statusAndExplain.statType, statusAndExplain.explain, true);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public I18NString nameThatObject(StatusModelInfo statusModelInfo) {
        Object[] objectArray = statusModelInfo.getIndexes();
        I18NMsgFormat i18NMsgFormat = new I18NMsgFormat(bundleName, "STATUS_NAME_PROTOCOL", objectArray);
        return i18NMsgFormat;
    }

    public I18NString nameThatTableObject(StatusModelInfo statusModelInfo) {
        I18NString i18NString = new I18NString(bundleName, "STATUS_TABLE_NAME_PROTO");
        return i18NString;
    }

    private StatusAndExplain evaluateStatus(int n, Object[] objectArray) {
        StatusAndExplain statusAndExplain = new StatusAndExplain();
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = new I18NMsgFormat(bundleName, "PROTOCOL", objectArray);
        switch (n) {
            case 1: {
                statusAndExplain.statType = StatusType.MARGINAL;
                objectArray2[1] = new I18NString(enumBundle, "ibm.nways.ppp.model.PppProtocolModel.Panel.PppProtocolState.closed");
                break;
            }
            case 2: {
                statusAndExplain.statType = StatusType.MARGINAL;
                objectArray2[1] = new I18NString(enumBundle, "ibm.nways.ppp.model.PppProtocolModel.Panel.PppProtocolState.listen");
                break;
            }
            case 3: {
                statusAndExplain.statType = StatusType.MARGINAL;
                objectArray2[1] = new I18NString(enumBundle, "ibm.nways.ppp.model.PppProtocolModel.Panel.PppProtocolState.requestSent");
                break;
            }
            case 4: {
                statusAndExplain.statType = StatusType.MARGINAL;
                objectArray2[1] = new I18NString(enumBundle, "ibm.nways.ppp.model.PppProtocolModel.Panel.PppProtocolState.ackReceived");
                break;
            }
            case 5: {
                statusAndExplain.statType = StatusType.MARGINAL;
                objectArray2[1] = new I18NString(enumBundle, "ibm.nways.ppp.model.PppProtocolModel.Panel.PppProtocolState.ackSent");
                break;
            }
            case 6: {
                statusAndExplain.statType = StatusType.NORMAL;
                objectArray2[1] = new I18NString(enumBundle, "ibm.nways.ppp.model.PppProtocolModel.Panel.PppProtocolState.opened");
                break;
            }
            case 7: {
                statusAndExplain.statType = StatusType.MARGINAL;
                objectArray2[1] = new I18NString(enumBundle, "ibm.nways.ppp.model.PppProtocolModel.Panel.PppProtocolState.termSent");
                break;
            }
            default: {
                statusAndExplain.statType = StatusType.UNKNOWN;
                objectArray2[1] = new I18NString(bundleName, "UNEXPECTED_PROTOCOL");
            }
        }
        statusAndExplain.explain = new I18NGiblets(bundleName, "STATUSMESSAGE", objectArray2);
        if (this.loggingOn) {
            System.out.println("ret.statType = " + statusAndExplain.statType);
            System.out.println("ret.explain = " + statusAndExplain.explain.getTranslation(Locale.getDefault()));
        }
        return statusAndExplain;
    }

    private class StatusAndExplain {
        StatusType statType;
        I18NGiblets explain;

        StatusAndExplain() {
            ActionPppProtocol.this = ActionPppProtocol.this;
        }
    }
}

